package gov.va.med.domain.model.validation;

import gov.va.med.domain.model.Prescription;

/**
 * Holds raw data for a prescription.  Validates, comverts and populates a 
 * Prescription from these values and populates a DtoListPayload with either
 * the good Prescription or the errant Prescription with a list of associated errors.  
 * <P>
 * Designed for use with an HL7 Message Decoder to allow validation to occur in the business tier.  
 * 
 * @author PII
 * @version $Id: RawPrescription.java,v 1.3 2005/09/16 21:43:35 ye.jin Exp $
 * @since MHV 2.0 <br>Jul 2, 2005
 */
public class RawPrescription extends BaseRawVO {
    
    //  Number fields
    public String PlaceOrderNum;
    public String NumberOfRefills;
    public String Quantity;
    public String DaysSupply;

    //  Date fields
    public String IssueDateTime;
    public String LastFillDate;
    public String ReleaseDate;
    public String ExpirationOrCancelDate;
    public String MhvStatusDate;

    //String fields
    public String PrescriptionNum;
    public String Ien;
    public String ProviderId;
    public String ProviderLastName;
    public String ProviderFirstName;

    public String Division;
    public String DivisionName;
    public String DrugName;
    public String DrugClass;
    public String Sig; 
    public String Remarks;
    public String MailOrWindow;
    public String PharmacyStatus;
    public String MhvRequestStatus;
    
    public Object createDto() {
      return new Prescription();
    }
    
    public void populateAndValidate(Object dto) {
        Prescription target = (Prescription)dto;
        target.setPrescriptionNum(validateNotNull(getPrescriptionNum(), "Prescription Number"));
        target.setIen(validateNotNull(getIen(), "IEN"));
        target.setDrugName(validateNotNull(getDrugName(), "Drug Name"));
        target.setIssueDate(validateNonNullDate(getIssueDateTime(), "Issue Date"));
        target.setLastFillDate(validateNonNullDate(getLastFillDate(), "Last Fill Date"));
        target.setReleaseDate(validateDate(getReleaseDate(), "Release Date"));
        target.setExpirationOrCancelDate(validateNonNullDate(getExpirationOrCancelDate(), "Expiration/Cancel Date"));
        target.setPharmacyStatus(validateNotNull(getPharmacyStatus(), "Pharmacy Status"));
        target.setQuantity(validateNonNullFloat(getQuantity(), "Quantity"));
        target.setDaysSupply(validateNonNullInteger(getDaysSupply(), "Days Supply"));
        target.setNumReFill(validateNonNullInteger(getNumberOfRefills(), "Number of Refills"));
        target.setProviderId(getProviderId());
        target.setProviderFirstName(getProviderFirstName());
        target.setProviderLastName(getProviderLastName());
        target.setPlaceOrderNumber(getPlaceOrderNum());
        target.setMailOrWindow(validateNotNull(getMailOrWindow(), "Mail/Window"));
        target.setDivision(validateInteger(getDivision(), "Division"));
        target.setDivisionName(getDivisionName());
        target.setRemarks(getRemarks());
        target.setMhvStatus(validateInteger(getMhvRequestStatus(), "MHV Status"));
        target.setMhvStatusDate(validateDate(getMhvStatusDate(), "MHV Status Date"));
        target.setSig(getSig());
    }
    
    public String getDaysSupply() {
        return DaysSupply;
    }
    
    public void setDaysSupply(String DaysSupply) {
        this.DaysSupply = DaysSupply;
    }
    
    public String getDivision() {
        return Division;
    }
    
    public void setDivision(String Division) {
        this.Division = Division;
    }
    
    public String getDivisionName() {
        return DivisionName;
    }
    
    public void setDivisionName(String DivisionName) {
        this.DivisionName = DivisionName;
    }
    
    public String getDrugClass() {
        return DrugClass;
    }
    
    public void setDrugClass(String DrugClass) {
        this.DrugClass = DrugClass;
    }
    
    public String getDrugName() {
        return DrugName;
    }
    
    public void setDrugName(String DrugName) {
        this.DrugName = DrugName;
    }
    
    public String getExpirationOrCancelDate() {
        return ExpirationOrCancelDate;
    }
    
    public void setExpirationOrCancelDate(
            String ExpirationOrCancelDate) {
        this.ExpirationOrCancelDate = ExpirationOrCancelDate;
    }
    
    public String getIen() {
        return Ien;
    }
    
    public void setIen(String Ien) {
        this.Ien = Ien;
    }
    
    public String getIssueDateTime() {
        return IssueDateTime;
    }
    
    public void setIssueDateTime(String IssueDateTime) {
        this.IssueDateTime = IssueDateTime;
    }
    
    public String getLastFillDate() {
        return LastFillDate;
    }
    public void setLastFillDate(String LastFillDate) {
        this.LastFillDate = LastFillDate;
    }
    
    public String getMailOrWindow() {
        return MailOrWindow;
    }
    
    public void setMailOrWindow(String MailOrWindow) {
        this.MailOrWindow = MailOrWindow;
    }
    
    public String getMhvRequestStatus() {
        return MhvRequestStatus;
    }
    
    public void setMhvRequestStatus(String MhvRequestStatus) {
        this.MhvRequestStatus = MhvRequestStatus;
    }
    
    public String getMhvStatusDate() {
        return MhvStatusDate;
    }
    
    public void setMhvStatusDate(String MhvStatusDate) {
        this.MhvStatusDate = MhvStatusDate;
    }
    
    public String getNumberOfRefills() {
        return NumberOfRefills;
    }
    
    public void setNumberOfRefills(String NumberOfRefills) {
        this.NumberOfRefills = NumberOfRefills;
    }
    
    public String getPharmacyStatus() {
        return PharmacyStatus;
    }
    
    public void setPharmacyStatus(String PharmacyStatus) {
        this.PharmacyStatus = PharmacyStatus;
    }
    
    public String getPlaceOrderNum() {
        return PlaceOrderNum;
    }
    
    public void setPlaceOrderNum(String PlaceOrderNum) {
        this.PlaceOrderNum = PlaceOrderNum;
    }
    
    public String getPrescriptionNum() {
        return PrescriptionNum;
    }
    
    public void setPrescriptionNum(String PrescriptionNum) {
        this.PrescriptionNum = PrescriptionNum;
    }
    
    public String getProviderFirstName() {
        return ProviderFirstName;
    }
    
    public void setProviderFirstName(String ProviderFirstName) {
        this.ProviderFirstName = ProviderFirstName;
    }
    
    public String getProviderId() {
        return ProviderId;
    }
    
    public void setProviderId(String ProviderId) {
        this.ProviderId = ProviderId;
    }
    
    public String getProviderLastName() {
        return ProviderLastName;
    }
    
    public void setProviderLastName(String ProviderLastName) {
        this.ProviderLastName = ProviderLastName;
    }
    
    public String getQuantity() {
        return Quantity;
    }
    
    public void setQuantity(String Quantity) {
        this.Quantity = Quantity;
    }
    
    public String getReleaseDate() {
        return ReleaseDate;
    }
    
    public void setReleaseDate(String ReleaseDate) {
        this.ReleaseDate = ReleaseDate;
    }
    
    public String getRemarks() {
        return Remarks;
    }
    
    public void setRemarks(String Remarks) {
        this.Remarks = Remarks;
    }
    
    public String getSig() {
        return Sig;
    }
    
    public void setSig(String Sig) {
        this.Sig = Sig;
    }
}

